//*****************************************************************************
//
// Copyright 2000-2004 by Mike Hall.
// See http://www.brainjar.com for terms of use.
//
// Edit by @wiki.jp(http://atwiki.jp/)
//*****************************************************************************

//----------------------------------------------------------------------------
// Code to determine the browser and version.
//----------------------------------------------------------------------------

function Browser() {

	var ua, s, i;

	this.isIE 	 = false;  // Internet Explorer
	this.isOP 	 = false;  // Opera
	this.isNS 	 = false;  // Netscape
	this.version = null;

	ua = navigator.userAgent;

	s = "Opera";
	if ((i = ua.indexOf(s)) >= 0) {
		this.isOP = true;
		this.version = parseFloat(ua.substr(i + s.length));
		return;
	}

	s = "Netscape6/";
	if ((i = ua.indexOf(s)) >= 0) {
		this.isNS = true;
		this.version = parseFloat(ua.substr(i + s.length));
		return;
	}

	// Treat any other "Gecko" browser as Netscape 6.1.

	s = "Gecko";
	if ((i = ua.indexOf(s)) >= 0) {
		this.isNS = true;
		this.version = 6.1;
		return;
	}

	s = "MSIE";
	if ((i = ua.indexOf(s))) {
		this.isIE = true;
		this.version = parseFloat(ua.substr(i + s.length));
		return;
	}
}

var browser = new Browser();

//----------------------------------------------------------------------------
// Code for handling the headmenu bar and active headmenuButton.
//----------------------------------------------------------------------------

var activeButton = null;

// Capture mouse clicks on the page so any active headmenuButton can be
// deactivated.

if (browser.isIE)
	document.onmousedown = pageMousedown;
else
	document.addEventListener("mousedown", pageMousedown, true);

function pageMousedown(event) {

	var el;

	// If there is no active headmenuButton, exit.

	if (activeButton == null)
		return;

	// Find the element that was clicked on.

	if (browser.isIE)
		el = window.event.srcElement;
	else
		el = (event.target.tagName ? event.target : event.target.parentNode);

	// If the active headmenuButton was clicked on, exit.

	if (el == activeButton)
		return;

	// If the element is not part of a headmenu, reset and clear the active
	// headmenuButton.

	if (getContainerWith(el, "DIV", "headmenu") == null) {
		resetButton(activeButton);
		activeButton = null;
	}
}

function headmenuButtonClick(event, headmenuId) {

	var headmenuButton;

	// Get the target headmenuButton element.

	if (browser.isIE)
		headmenuButton = window.event.srcElement;
	else
		headmenuButton = event.currentTarget;

	// Blur focus from the link to remove that annoying outline.

	headmenuButton.blur();

	// Associate the named headmenu to this headmenuButton if not already done.
	// Additionally, initialize headmenu display.

	if (headmenuButton.headmenu == null) {
		headmenuButton.headmenu = document.getElementById(headmenuId);
		if (headmenuButton.headmenu.isInitialized == null)
			headmenuInit(headmenuButton.headmenu);
	}

	// Reset the currently active headmenuButton, if any.

	if (activeButton != null)
		resetButton(activeButton);

	// Activate this headmenuButton, unless it was the currently active one.

	if (headmenuButton != activeButton) {
		depressButton(headmenuButton);
		activeButton = headmenuButton;
	}
	else
		activeButton = null;

	return false;
}

function headmenuButtonMouseover(event, headmenuId) {

	var headmenuButton;

	// Find the target headmenuButton element.

	if (browser.isIE)
		headmenuButton = window.event.srcElement;
	else
		headmenuButton = event.currentTarget;

	// If any other headmenuButton headmenu is active, make this one active instead.

	if (activeButton != null && activeButton != headmenuButton)
		headmenuButtonClick(event, headmenuId);
}

function depressButton(headmenuButton) {

	var x, y;

	// Update the headmenuButton's style class to make it look like it's
	// depressed.

	headmenuButton.className += " headmenuButtonActive";

	// Position the associated drop down headmenu under the headmenuButton and
	// show it.

	x = getPageOffsetLeft(headmenuButton);
	y = getPageOffsetTop(headmenuButton) + headmenuButton.offsetHeight;

	// For IE, adjust position.

	if (browser.isIE) {
		x += headmenuButton.offsetParent.clientLeft;
		y += headmenuButton.offsetParent.clientTop;
	}

	headmenuButton.headmenu.style.left = x + "px";
	headmenuButton.headmenu.style.top  = y + "px";
	headmenuButton.headmenu.style.visibility = "visible";

	// For IE; size, position and show the headmenu's IFRAME as well.

	if (headmenuButton.headmenu.iframeEl != null)
	{
		headmenuButton.headmenu.iframeEl.style.left = headmenuButton.headmenu.style.left;
		headmenuButton.headmenu.iframeEl.style.top	= headmenuButton.headmenu.style.top;
		headmenuButton.headmenu.iframeEl.style.width	= headmenuButton.headmenu.offsetWidth + "px";
		headmenuButton.headmenu.iframeEl.style.height = headmenuButton.headmenu.offsetHeight + "px";
		headmenuButton.headmenu.iframeEl.style.display = "";
	}
}

function resetButton(headmenuButton) {

	// Restore the headmenuButton's style class.

	removeClassName(headmenuButton, "headmenuButtonActive");

	// Hide the headmenuButton's headmenu, first closing any sub headmenus.

	if (headmenuButton.headmenu != null) {
		closeSubMenu(headmenuButton.headmenu);
		headmenuButton.headmenu.style.visibility = "hidden";

		// For IE, hide headmenu's IFRAME as well.

		if (headmenuButton.headmenu.iframeEl != null)
			headmenuButton.headmenu.iframeEl.style.display = "none";
	}
}

//----------------------------------------------------------------------------
// Code to handle the headmenus and sub headmenus.
//----------------------------------------------------------------------------

function headmenuMouseover(event) {

	var headmenu;

	// Find the target headmenu element.

	if (browser.isIE)
		headmenu = getContainerWith(window.event.srcElement, "DIV", "headmenu");
	else
		headmenu = event.currentTarget;

	// Close any active sub headmenu.

	if (headmenu.activeItem != null)
		closeSubMenu(headmenu);
}

function headmenuItemMouseover(event, headmenuId) {

	var item, headmenu, x, y;

	// Find the target item element and its parent headmenu element.

	if (browser.isIE)
		item = getContainerWith(window.event.srcElement, "A", "headmenuItem");
	else
		item = event.currentTarget;
	headmenu = getContainerWith(item, "DIV", "headmenu");

	// Close any active sub headmenu and mark this one as active.

	if (headmenu.activeItem != null)
		closeSubMenu(headmenu);
	headmenu.activeItem = item;

	// Highlight the item element.

	item.className += " headmenuItemHighlight";

	// Initialize the sub headmenu, if not already done.

	if (item.subMenu == null) {
		item.subMenu = document.getElementById(headmenuId);
		if (item.subMenu.isInitialized == null)
			headmenuInit(item.subMenu);
	}

	// Get position for subheadmenu based on the headmenu item.

	x = getPageOffsetLeft(item) + item.offsetWidth;
	y = getPageOffsetTop(item);

	// Adjust position to fit in view.

	var maxX, maxY;

	if (browser.isIE) {
		maxX = Math.max(document.documentElement.scrollLeft, document.body.scrollLeft) +
			(document.documentElement.clientWidth != 0 ? document.documentElement.clientWidth : document.body.clientWidth);
		maxY = Math.max(document.documentElement.scrollTop, document.body.scrollTop) +
			(document.documentElement.clientHeight != 0 ? document.documentElement.clientHeight : document.body.clientHeight);
	}
	if (browser.isOP) {
		maxX = document.documentElement.scrollLeft + window.innerWidth;
		maxY = document.documentElement.scrollTop  + window.innerHeight;
	}
	if (browser.isNS) {
		maxX = window.scrollX + window.innerWidth;
		maxY = window.scrollY + window.innerHeight;
	}
	maxX -= item.subMenu.offsetWidth;
	maxY -= item.subMenu.offsetHeight;

	if (x > maxX)
		x = Math.max(0, x - item.offsetWidth - item.subMenu.offsetWidth
			+ (headmenu.offsetWidth - item.offsetWidth));
	y = Math.max(0, Math.min(y, maxY));

	// Position and show it.

	item.subMenu.style.left 			= x + "px";
	item.subMenu.style.top				= y + "px";
	item.subMenu.style.visibility = "visible";

	// For IE; size, position and show the headmenu's IFRAME as well.

	if (item.subMenu.iframeEl != null)
	{
		item.subMenu.iframeEl.style.left		= item.subMenu.style.left;
		item.subMenu.iframeEl.style.top 		= item.subMenu.style.top;
		item.subMenu.iframeEl.style.width 	= item.subMenu.offsetWidth + "px";
		item.subMenu.iframeEl.style.height	= item.subMenu.offsetHeight + "px";
		item.subMenu.iframeEl.style.display = "";
	}

	// Stop the event from bubbling.

	if (browser.isIE)
		window.event.cancelBubble = true;
	else
		event.stopPropagation();
}

function closeSubMenu(headmenu) {

	if (headmenu == null || headmenu.activeItem == null)
		return;

	// Recursively close any sub headmenus.

	if (headmenu.activeItem.subMenu != null) {
		closeSubMenu(headmenu.activeItem.subMenu);


		// Hide the sub headmenu.
		headmenu.activeItem.subMenu.style.visibility = "hidden";

		// For IE, hide the sub headmenu's IFRAME as well.

		if (headmenu.activeItem.subMenu.iframeEl != null)
			headmenu.activeItem.subMenu.iframeEl.style.display = "none";

		headmenu.activeItem.subMenu = null;
	}

	// Deactivate the active headmenu item.

	removeClassName(headmenu.activeItem, "headmenuItemHighlight");
	headmenu.activeItem = null;
}

//----------------------------------------------------------------------------
// Code to initialize headmenus.
//----------------------------------------------------------------------------

function headmenuInit(headmenu) {

	var itemList, spanList;
	var textEl, arrowEl;
	var itemWidth;
	var w, dw;
	var i, j;

	// For IE, replace arrow characters.

	if (browser.isIE) {
		headmenu.style.lineHeight = "2.5ex";
		spanList = headmenu.getElementsByTagName("SPAN");
		for (i = 0; i < spanList.length; i++)
			if (hasClassName(spanList[i], "headmenuItemArrow")) {
				spanList[i].style.fontFamily = "Webdings";
				spanList[i].firstChild.nodeValue = "4";
			}
	}

	// Find the width of a headmenu item.

	itemList = headmenu.getElementsByTagName("A");
	if (itemList.length > 0)
		itemWidth = itemList[0].offsetWidth;
	else
		return;

	// For items with arrows, add padding to item text to make the
	// arrows flush right.

	for (i = 0; i < itemList.length; i++) {
		spanList = itemList[i].getElementsByTagName("SPAN");
		textEl	= null;
		arrowEl = null;
		for (j = 0; j < spanList.length; j++) {
			if (hasClassName(spanList[j], "headmenuItemText"))
				textEl = spanList[j];
			if (hasClassName(spanList[j], "headmenuItemArrow")) {
				arrowEl = spanList[j];
			}
		}
		if (textEl != null && arrowEl != null) {
			textEl.style.paddingRight = (itemWidth 
				- (textEl.offsetWidth + arrowEl.offsetWidth)) + "px";

			// For Opera, remove the negative right margin to fix a display bug.

			if (browser.isOP)
				arrowEl.style.marginRight = "0px";
		}
	}

	// Fix IE hover problem by setting an explicit width on first item of
	// the headmenu.

	if (browser.isIE) {
		w = itemList[0].offsetWidth;
		itemList[0].style.width = w + "px";
		dw = itemList[0].offsetWidth - w;
		w -= dw;
		itemList[0].style.width = w + "px";
	}

	// Fix the IE display problem (SELECT elements and other windowed controls
	// overlaying the headmenu) by adding an IFRAME under the headmenu.

	if (browser.isIE) {
		var iframeEl = document.createElement("IFRAME");
		iframeEl.frameBorder = 0;
		iframeEl.src = "javascript:false;";
		iframeEl.style.display = "none";
		iframeEl.style.position = "absolute";
		iframeEl.style.filter = "progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)";
		headmenu.iframeEl = headmenu.parentNode.insertBefore(iframeEl, headmenu);
	}

	// Mark headmenu as initialized.

	headmenu.isInitialized = true;
}

//----------------------------------------------------------------------------
// General utility functions.
//----------------------------------------------------------------------------

function getContainerWith(node, tagName, className) {

	// Starting with the given node, find the nearest containing element
	// with the specified tag name and style class.

	while (node != null) {
		if (node.tagName != null && node.tagName == tagName &&
				hasClassName(node, className))
			return node;
		node = node.parentNode;
	}

	return node;
}

function hasClassName(el, name) {

	var i, list;

	// Return true if the given element currently has the given class
	// name.

	list = el.className.split(" ");
	for (i = 0; i < list.length; i++)
		if (list[i] == name)
			return true;

	return false;
}

function removeClassName(el, name) {

	var i, curList, newList;

	if (el.className == null)
		return;

	// Remove the given class name from the element's className property.

	newList = new Array();
	curList = el.className.split(" ");
	for (i = 0; i < curList.length; i++)
		if (curList[i] != name)
			newList.push(curList[i]);
	el.className = newList.join(" ");
}

function getPageOffsetLeft(el) {

	var x;

	// Return the x coordinate of an element relative to the page.

	x = el.offsetLeft;
	if (el.offsetParent != null)
		x += getPageOffsetLeft(el.offsetParent);

	return x;
}

function getPageOffsetTop(el) {

	var y;

	// Return the x coordinate of an element relative to the page.

	y = el.offsetTop;
	if (el.offsetParent != null)
		y += getPageOffsetTop(el.offsetParent);

	return y;
}


//----------------------------------------------------------------------------
// Added by @wiki.jp
//----------------------------------------------------------------------------

function onw(tUrl){
	//Open New Window
	window.open(tUrl, '_blank','width=700,height=700,resizable=1,scrollbars=1,location=1');
	return false;
}


function formClear(targetElement){
	if(targetElement.value == targetElement.defaultValue){
		targetElement.value = "";
	}
}